<!DOCTYPE html>
<html lang="{{app()->getLocale()}}" data-layout-default="vertical" data-sidebar-size="lg" data-topbar="light" data-sidebar="dark">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{csrf_token()}}" />
    <title>{{(site_settings('site_name'))}} - {{translate($title)}}</title>
    <link rel="shortcut icon" href="{{show_image('assets/images/backend/logoIcon/'.site_settings("site_favicon"),file_path()['favicon']['size'])}}" type="image/x-icon">
    <link href="{{asset('assets/global/css/bootstrap.min.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{asset('assets/global/css/icons.min.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{asset('assets/global/css/simplebar.min.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{asset('assets/backend/css/root.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{asset('assets/backend/css/style.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{asset('assets/backend/css/custom.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{asset('assets/global/css/toastr.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{asset('assets/global/css/select2.min.css')}}" rel="stylesheet" />
    <link href="{{asset('assets/global/css/select2.css')}}" rel="stylesheet" />
    <link href="{{asset('assets/backend/css/flatpickr.min.css')}}" rel="stylesheet" type="text/css" />

    @stack('style-include')
    @stack('style-push')

    <style>

        .update-ui {
            padding: 80px 0;
            min-height: 100vh;
            display: flex;
            align-items: center;
            overflow-x: hidden;
            background-image: linear-gradient(to top, #f3e7e9 0%, #e3eeff 99%, #e3eeff 100%);
        }

        .update-title {
            position: relative;
            font-size: 2.2rem;
            font-weight: 700;
            position: relative;
            display: inline-block;
            z-index: 1;
        }

        .update-title::after {
            content: url("{{asset('assets/images/title-vector.png')}}");
            position: absolute;
            right: 0px;
            display: inline-block;
            top: 12px;
            width: 50px !important;
            height: 30px;
            z-index: -1;
        }

    </style>
   
</head>
<body>
   
    @php
            $baseURL = url('/');

            $configFilePath = $baseURL.'/'.'manual.json';
            $configJson     = json_decode(file_get_contents($configFilePath), true);

    @endphp
   


    <section class="update-ui">
        <div class="container">
            <div class="row g-5 align-items-center">
                <div class="col-lg-6">
                    <h2 class="mb-3 update-title">
                         {{$title}}
                    </h2>
                    <p>
                        {{Arr::get($configJson,'note')}}
                    </p>

                    <div class="mt-5">
                        <a href="{{route('admin.manual.update.application')}}" class="btn btn-success">
                            {{translate("Update")}} V{{Arr::get($configJson,'version')}}
                        </a>
                    </div>
                </div>
                <div class="col-lg-6">
                    <svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 1444 1405" fill="none">
                        <path d="M1274.38 1144.26H235.124C219.803 1136.43 206.436 1127.66 195.18 1117.82C44.5481 985.47 381.691 799.662 293.829 726.948C206.045 654.162 247.006 469.504 351.752 432.931C456.499 396.359 392.009 283.121 441.49 204.156C525.287 70.5118 758.699 68.2128 876.735 156.375C994.77 244.465 1225.45 247.555 1202.47 424.453C1179.48 601.351 1331.29 631.314 1369.12 707.117C1408.75 786.585 1307.76 806.99 1411.02 907.654C1486.14 980.87 1426.03 1077.08 1274.38 1144.26Z" fill="url(#paint0_linear_40_2453)"/>
                        <g opacity="0.2">
                        <path d="M657.077 1171.27C1019.97 1171.27 1314.15 1165.04 1314.15 1157.35C1314.15 1149.66 1019.97 1143.42 657.077 1143.42C294.183 1143.42 0 1149.66 0 1157.35C0 1165.04 294.183 1171.27 657.077 1171.27Z" fill="#9677EF"/>
                        <path d="M919.248 1404.14C1095.34 1404.14 1238.09 1393.78 1238.09 1381C1238.09 1368.22 1095.34 1357.85 919.248 1357.85C743.154 1357.85 600.401 1368.22 600.401 1381C600.401 1393.78 743.154 1404.14 919.248 1404.14Z" fill="#9677EF"/>
                        <path d="M1153.84 1250.74C1247.71 1250.74 1323.81 1244.12 1323.81 1235.94C1323.81 1227.77 1247.71 1221.14 1153.84 1221.14C1059.97 1221.14 983.866 1227.77 983.866 1235.94C983.866 1244.12 1059.97 1250.74 1153.84 1250.74Z" fill="#9677EF"/>
                        <path d="M476.975 1239.79C567.006 1239.79 639.991 1231.98 639.991 1222.34C639.991 1212.7 567.006 1204.88 476.975 1204.88C386.944 1204.88 313.959 1212.7 313.959 1222.34C313.959 1231.98 386.944 1239.79 476.975 1239.79Z" fill="#9677EF"/>
                        </g>
                        <g opacity="0.5">
                        <path d="M310.473 1094.55L307.101 1095.31C307.101 1095.31 303.926 1082.33 301.555 1062.46C299.225 1042.63 298.311 1015.82 301.47 989.324C304.416 962.814 310.968 936.819 317.787 918.027C324.409 899.145 330.509 887.246 330.509 887.246L333.632 888.732C333.632 888.732 327.599 900.498 321.049 919.176C314.303 937.765 307.822 963.484 304.907 989.712C301.781 1015.92 302.687 1042.45 304.991 1062.07C307.335 1081.71 310.473 1094.55 310.473 1094.55Z" fill="#1A2050"/>
                        <path d="M343.813 918.257C333.176 920.33 322.381 914.169 322.381 914.169C322.381 914.169 324.063 911.548 327.124 908.712C330.31 905.924 334.836 902.947 340.218 902.109C350.983 900.497 361.32 907.579 361.32 907.579C361.32 907.579 354.514 916.254 343.813 918.257Z" fill="#1A2050"/>
                        <path d="M294.497 925.549C301.423 934.416 313.927 935.522 313.927 935.522C313.927 935.522 314.725 923.186 308.219 914.11C301.689 904.982 289.405 902.885 289.405 902.885C289.405 902.885 288.894 906.294 289.214 910.826C289.647 915.394 291.052 921.092 294.497 925.549Z" fill="#1A2050"/>
                        <path d="M313.554 894.717C317.54 900.938 325.571 902.589 325.571 902.589C325.571 902.589 326.836 894.514 323.164 888.272C319.422 881.979 311.505 879.896 311.505 879.896C311.505 879.896 309.466 888.432 313.554 894.717Z" fill="#1A2050"/>
                        <path d="M330.37 877.087C327.339 883.957 330.313 891.599 330.313 891.599C330.313 891.599 337.752 888.281 340.66 881.767C343.73 875.335 341.246 867.453 341.246 867.453C341.246 867.453 333.613 870.321 330.37 877.087Z" fill="#1A2050"/>
                        <path d="M337.625 954.645C324.948 958.685 310.884 952.922 310.884 952.922C310.884 952.922 317.768 939.1 330.857 935.693C343.86 932.324 357.367 939.497 357.367 939.497C357.367 939.497 350.288 950.652 337.625 954.645Z" fill="#1A2050"/>
                        <path d="M278.808 971.474C288.791 981.172 304.194 980.296 304.194 980.296C304.194 980.296 302.988 965.18 293.681 955.108C284.246 944.948 268.988 944.327 268.988 944.327C268.988 944.327 268.69 961.686 278.808 971.474Z" fill="#1A2050"/>
                        <path d="M330.093 1000.22C318.202 1006.19 303.391 1002.68 303.391 1002.68C303.391 1002.68 304.538 999.019 307.167 994.645C309.893 990.279 314.332 985.277 320.381 982.539C332.683 977.175 347.174 982.153 347.174 982.153C347.174 982.153 341.925 994.312 330.093 1000.22Z" fill="#1A2050"/>
                        <path d="M274.587 1026.01C286.067 1034.04 301.071 1030.76 301.071 1030.76C301.071 1030.76 300.171 1027.06 297.838 1022.32C295.705 1017.59 292.205 1011.76 286.655 1007.51C275.838 998.953 260.648 1000.71 260.648 1000.71C260.648 1000.71 263.077 1017.91 274.587 1026.01Z" fill="#1A2050"/>
                        <path d="M329.586 1044.19C318.623 1051.87 303.491 1050.63 303.491 1050.63C303.491 1050.63 305.835 1035.38 317.383 1028.18C328.677 1021.05 343.75 1023.82 343.75 1023.82C343.75 1023.82 340.326 1036.59 329.586 1044.19Z" fill="#1A2050"/>
                        <path d="M278.626 1078.06C291.098 1084.28 305.462 1078.74 305.462 1078.74C305.462 1078.74 299.706 1064.72 287.789 1057.92C275.632 1051.08 260.933 1055.1 260.933 1055.1C260.933 1055.1 265.868 1071.81 278.626 1078.06Z" fill="#1A2050"/>
                        </g>
                        <path d="M1082.56 1352.71C1111.7 1268.78 1211.58 1250.74 1211.58 1250.74C1211.58 1250.74 1188.69 1343 1147.76 1372.13H1079.1L1082.56 1352.71Z" fill="#155263"/>
                        <path d="M1102.45 1372.13C1102.45 1372.13 1132.04 1312.01 1163.48 1295.83C1163.48 1295.83 1131.58 1330.05 1114.47 1371.66L1102.45 1372.13Z" fill="#123F49"/>
                        <path d="M1239.72 1377.51C1289.63 1322.9 1265.15 1255.1 1265.15 1255.1C1265.15 1255.1 1143.68 1300.3 1121.08 1374.68L1239.72 1377.51Z" fill="#1B687A"/>
                        <path d="M1170.67 1376.25L1220.26 1318.5L1190.13 1376.88L1170.67 1376.25Z" fill="#155263"/>
                        <path d="M799.999 1143.39C892.211 1034.18 855.284 909.078 922.078 904.949C1005.04 899.821 985.641 1046.82 1029.76 1043.93C1073.87 1041.03 1087.55 1089.56 1022.78 1117.49C958.023 1145.42 799.999 1143.39 799.999 1143.39Z" fill="#175B66"/>
                        <path d="M565.505 1143.42C758.421 1105.11 743.457 922.16 879.156 1014.66C985.797 1087.35 981.504 838.168 1103.55 910.41C1244.68 993.941 1214.99 1143.42 1214.99 1143.42L565.505 1143.42Z" fill="#1B687A"/>
                        <path d="M831.894 1143.42C928.659 1120.48 940.599 1044.04 987.031 1063.66C1033.46 1083.29 1022.85 1130.91 1022.85 1130.91C1022.85 1130.91 1043.77 1074.47 1067.14 1072.25C1090.51 1070.03 1168.33 1143.42 1168.33 1143.42H831.894Z" fill="#2D7F8C"/>
                        <g opacity="0.5">
                        <path d="M274.015 1105.64L269.396 1106.69C269.396 1106.69 265.047 1088.9 261.799 1061.69C258.608 1034.52 257.356 997.796 261.682 961.507C265.717 925.195 274.692 889.588 284.032 863.847C293.102 837.983 301.458 821.684 301.458 821.684L305.735 823.719C305.735 823.719 297.471 839.835 288.5 865.42C279.26 890.882 270.382 926.111 266.389 962.038C262.107 997.942 263.349 1034.27 266.504 1061.14C269.717 1088.05 274.015 1105.64 274.015 1105.64Z" fill="#1A2050"/>
                        <path d="M319.683 864.162C305.113 867.001 290.327 858.563 290.327 858.563C290.327 858.563 292.631 854.972 296.824 851.087C301.189 847.269 307.388 843.19 314.759 842.043C329.504 839.835 343.664 849.535 343.664 849.535C343.664 849.535 334.341 861.419 319.683 864.162Z" fill="#1A2050"/>
                        <path d="M252.133 874.151C261.62 886.297 278.748 887.812 278.748 887.812C278.748 887.812 279.841 870.914 270.93 858.483C261.985 845.98 245.159 843.107 245.159 843.107C245.159 843.107 244.458 847.777 244.898 853.984C245.49 860.241 247.414 868.046 252.133 874.151Z" fill="#1A2050"/>
                        <path d="M278.237 831.919C283.697 840.441 294.698 842.7 294.698 842.7C294.698 842.7 296.431 831.641 291.401 823.091C286.275 814.471 275.432 811.617 275.432 811.617C275.432 811.617 272.637 823.311 278.237 831.919Z" fill="#1A2050"/>
                        <path d="M301.269 807.77C297.118 817.18 301.191 827.647 301.191 827.647C301.191 827.647 311.381 823.102 315.364 814.18C319.569 805.369 316.167 794.573 316.167 794.573C316.167 794.573 305.712 798.502 301.269 807.77Z" fill="#1A2050"/>
                        <path d="M284.806 898.131C289.169 893.909 294.898 889.877 301.937 888.045C319.748 883.43 338.249 893.256 338.249 893.256C338.249 893.256 328.552 908.535 311.207 914.004C293.842 919.538 274.579 911.644 274.579 911.644C274.579 911.644 278.058 904.661 284.806 898.131Z" fill="#1A2050"/>
                        <path d="M230.643 937.056C244.318 950.34 265.416 949.141 265.416 949.141C265.416 949.141 263.764 928.435 251.016 914.639C238.092 900.722 217.192 899.871 217.192 899.871C217.192 899.871 216.784 923.649 230.643 937.056Z" fill="#1A2050"/>
                        <path d="M300.89 976.434C284.602 984.607 264.314 979.804 264.314 979.804C264.314 979.804 265.886 974.787 269.487 968.795C273.221 962.814 279.302 955.963 287.587 952.213C304.438 944.865 324.286 951.684 324.286 951.684C324.286 951.684 317.097 968.339 300.89 976.434Z" fill="#1A2050"/>
                        <path d="M224.861 1011.76C240.585 1022.75 261.138 1018.27 261.138 1018.27C261.138 1018.27 259.906 1013.2 256.71 1006.7C253.788 1000.22 248.994 992.239 241.392 986.421C226.575 974.695 205.768 977.104 205.768 977.104C205.768 977.104 209.095 1000.67 224.861 1011.76Z" fill="#1A2050"/>
                        <path d="M300.195 1036.66C285.178 1047.18 264.451 1045.48 264.451 1045.48C264.451 1045.48 267.661 1024.59 283.48 1014.73C298.951 1004.96 319.597 1008.75 319.597 1008.75C319.597 1008.75 314.907 1026.25 300.195 1036.66Z" fill="#1A2050"/>
                        <path d="M230.393 1083.06C247.477 1091.58 267.152 1083.99 267.152 1083.99C267.152 1083.99 259.268 1064.78 242.944 1055.46C226.291 1046.1 206.157 1051.6 206.157 1051.6C206.157 1051.6 212.918 1074.49 230.393 1083.06Z" fill="#1A2050"/>
                        </g>
                        <path d="M372.851 1143.39C465.063 1034.18 428.136 909.078 494.93 904.949C577.888 899.821 558.493 1046.82 602.61 1043.93C646.726 1041.03 660.399 1089.56 595.637 1117.49C530.875 1145.42 372.851 1143.39 372.851 1143.39Z" fill="#175B66"/>
                        <path d="M138.357 1143.42C331.273 1105.11 316.309 922.16 452.008 1014.66C558.649 1087.35 554.356 838.168 676.406 910.41C817.53 993.941 787.843 1143.42 787.843 1143.42L138.357 1143.42Z" fill="#1B687A"/>
                        <path d="M404.746 1143.42C501.511 1120.48 513.451 1044.04 559.883 1063.66C606.315 1083.29 595.702 1130.91 595.702 1130.91C595.702 1130.91 616.622 1074.47 639.991 1072.25C663.36 1070.03 741.188 1143.42 741.188 1143.42H404.746Z" fill="#2D7F8C"/>
                        <path d="M774.314 127.374C774.314 114.933 765.063 104.659 753.066 103.039C750.803 80.649 731.898 63.173 708.911 63.173C707.603 63.173 706.311 63.241 705.031 63.352C703.823 28.161 674.933 0 639.448 0C606.024 0 578.455 24.988 574.353 57.298C570.125 54.79 564.964 53.689 559.485 54.769C551.596 56.324 545.209 62.493 543.307 70.306C542.206 74.83 542.66 79.137 544.137 82.933C542.87 82.793 541.585 82.714 540.281 82.714C521.386 82.714 506.027 97.854 505.675 116.665C505.312 136.062 521.788 151.939 541.188 151.939H749.717C763.052 151.939 774.089 141.323 774.308 127.99C774.312 127.785 774.314 127.58 774.314 127.374Z" fill="white"/>
                        <path d="M1211.58 302.795C1211.58 294.902 1205.71 288.384 1198.1 287.357C1196.66 273.152 1184.67 262.065 1170.08 262.065C1169.25 262.065 1168.43 262.108 1167.62 262.179C1166.85 239.853 1148.53 221.987 1126.01 221.987C1104.81 221.987 1087.32 237.84 1084.72 258.338C1082.03 256.747 1078.76 256.048 1075.28 256.733C1070.28 257.72 1066.23 261.633 1065.02 266.59C1064.32 269.46 1064.61 272.193 1065.55 274.601C1064.74 274.512 1063.93 274.462 1063.1 274.462C1051.11 274.462 1041.37 284.067 1041.15 296.001C1040.92 308.307 1051.37 318.379 1063.68 318.379H1195.97C1204.43 318.379 1211.43 311.644 1211.57 303.186C1211.57 303.057 1211.58 302.927 1211.58 302.795Z" fill="white"/>
                        <path d="M1301.74 525.751L1265.94 499.292C1267.6 492.345 1270.8 485.648 1275.58 479.721C1287.57 464.892 1306.33 458.779 1323.81 462.246L1292.36 501.17L1301.74 525.751Z" fill="#41B2C4"/>
                        <path d="M1271.53 526.222L1173.31 647.773C1165.15 657.872 1166.72 672.675 1176.82 680.835C1186.92 688.995 1201.73 687.424 1209.89 677.324L1308.1 555.773L1271.53 526.222Z" fill="#41B2C4"/>
                        <path d="M1266.01 570.459C1258.71 564.565 1248.02 565.701 1242.13 572.995L1181.87 647.575C1175.98 654.869 1177.11 665.56 1184.41 671.453C1191.7 677.347 1202.39 676.211 1208.28 668.917L1268.54 594.337C1274.44 587.043 1273.3 576.352 1266.01 570.459Z" fill="#283149"/>
                        <path d="M1198.51 662.798C1196.59 665.174 1193.11 665.544 1190.73 663.624C1188.35 661.704 1187.98 658.221 1189.9 655.845C1191.82 653.469 1195.31 653.099 1197.68 655.019C1200.06 656.939 1200.43 660.422 1198.51 662.798Z" fill="#FFD9E8"/>
                        <path d="M1352.72 542.047C1335.51 563.346 1304.29 566.654 1282.99 549.444C1267.62 537.024 1261.61 517.307 1265.94 499.293L1301.74 525.752L1328.22 530.147L1359.67 491.223C1366.73 507.585 1364.7 527.218 1352.72 542.047Z" fill="#41B2C4"/>
                        <path d="M361.32 456.214V417.224H330.266C328.267 408.851 324.955 401.041 320.581 393.918L342.575 371.924L315.02 344.369L293.025 366.363C285.902 361.989 278.091 358.74 269.719 356.678V325.624H230.792V356.678C222.419 358.74 214.609 361.989 207.423 366.363L185.491 344.369L157.936 371.924L179.868 393.918C175.557 401.041 172.245 408.852 170.246 417.224H139.192V456.214H170.246C172.245 464.524 175.557 472.397 179.868 479.521L157.936 501.453L185.491 529.008L207.423 507.076C214.609 511.387 222.419 514.699 230.792 516.698V547.753H269.719V516.698C278.092 514.699 285.902 511.387 293.025 507.076L315.019 529.008L342.574 501.453L320.58 479.521C324.954 472.398 328.265 464.525 330.265 456.214H361.32ZM250.224 485.207C223.481 485.207 201.799 463.463 201.799 436.72C201.799 409.915 223.481 388.233 250.224 388.233C277.029 388.233 298.711 409.915 298.711 436.72C298.712 463.462 277.03 485.207 250.224 485.207Z" fill="#EC5F92"/>
                        <path d="M583.675 400.774V361.784H552.621C550.621 353.411 547.31 345.601 542.936 338.478L564.93 316.484L537.375 288.929L515.381 310.923C508.258 306.549 500.447 303.3 492.075 301.238V270.184H453.147V301.238C444.774 303.3 436.964 306.549 429.778 310.923L407.846 288.929L380.291 316.484L402.223 338.478C397.912 345.601 394.6 353.412 392.601 361.784H361.546V400.774H392.601C394.6 409.084 397.912 416.957 402.223 424.081L380.291 446.013L407.846 473.568L429.778 451.636C436.964 455.947 444.774 459.259 453.147 461.258V492.313H492.075V461.258C500.448 459.259 508.258 455.947 515.381 451.636L537.375 473.568L564.93 446.013L542.936 424.081C547.31 416.958 550.621 409.085 552.621 400.774H583.675ZM472.58 429.766C445.837 429.766 424.155 408.022 424.155 381.279C424.155 354.474 445.837 332.792 472.58 332.792C499.385 332.792 521.067 354.474 521.067 381.279C521.067 408.022 499.385 429.766 472.58 429.766Z" fill="#EC5F92"/>
                        <path d="M488.854 568.072V543.124H468.983C467.703 537.767 465.584 532.769 462.786 528.211L476.859 514.137L459.227 496.505L445.153 510.578C440.595 507.779 435.597 505.7 430.24 504.381V484.51H405.331V504.381C399.974 505.701 394.976 507.78 390.378 510.578L376.344 496.505L358.712 514.137L372.746 528.211C369.987 532.769 367.868 537.767 366.589 543.124H346.718V568.073H366.589C367.868 573.391 369.987 578.428 372.746 582.986L358.712 597.02L376.344 614.652L390.378 600.618C394.976 603.377 399.974 605.496 405.331 606.775V626.646H430.24V606.774C435.597 605.495 440.595 603.376 445.153 600.617L459.227 614.651L476.859 597.019L462.786 582.985C465.585 578.427 467.704 573.389 468.983 568.072H488.854ZM417.766 586.624C400.654 586.624 386.78 572.71 386.78 555.598C386.78 538.446 400.654 524.572 417.766 524.572C434.918 524.572 448.792 538.446 448.792 555.598C448.792 572.71 434.918 586.624 417.766 586.624Z" fill="#EC5F92"/>
                        <path d="M781.531 1023.47H721.038V1117.22H781.531V1023.47Z" fill="#39283D"/>
                        <path d="M830.001 1144.26H672.567C671.237 1144.26 670.159 1143.18 670.159 1141.85C670.159 1123.27 685.224 1108.21 703.807 1108.21H798.762C817.345 1108.21 832.409 1123.27 832.409 1141.85C832.409 1143.18 831.331 1144.26 830.001 1144.26Z" fill="#4E3654"/>
                        <path d="M1077.7 1063.14H424.871C405.517 1063.14 389.828 1047.45 389.828 1028.09V642.076C389.828 622.722 405.517 607.033 424.871 607.033H1077.7C1097.05 607.033 1112.74 622.723 1112.74 642.076V1028.09C1112.74 1047.45 1097.05 1063.14 1077.7 1063.14Z" fill="#4E3654"/>
                        <path d="M1087.62 630.222H414.953V1003.64H1087.62V630.222Z" fill="url(#paint1_linear_40_2453)"/>
                        <path d="M764.659 1036.97C765.855 1029.6 760.849 1022.65 753.478 1021.46C746.107 1020.26 739.162 1025.26 737.965 1032.64C736.769 1040.01 741.775 1046.95 749.146 1048.15C756.517 1049.34 763.462 1044.34 764.659 1036.97Z" fill="#39283D"/>
                        <path d="M873.467 900.716H656.143C652.899 900.716 650.269 898.086 650.269 894.842C650.269 891.598 652.899 888.968 656.143 888.968H873.467C876.711 888.968 879.341 891.598 879.341 894.842C879.341 898.086 876.711 900.716 873.467 900.716Z" fill="white"/>
                        <path d="M775.483 900.716H656.143C652.899 900.716 650.269 898.086 650.269 894.842C650.269 891.598 652.899 888.968 656.143 888.968H775.483C778.727 888.968 781.357 891.598 781.357 894.842C781.356 898.086 778.727 900.716 775.483 900.716Z" fill="#F9ED32"/>
                        <path d="M718.995 862.889L716.404 877.657H722.157L721.931 878.915H714.568L717.386 862.889H718.995Z" fill="white"/>
                        <path d="M729.712 879.099C726.576 879.099 724.462 877.103 724.462 873.958C724.462 869.698 727.607 866.209 731.942 866.209C735.078 866.209 737.208 868.205 737.208 871.35C737.209 875.635 734.006 879.099 729.712 879.099ZM729.897 877.749C733.243 877.749 735.566 874.789 735.566 871.443C735.566 868.827 733.797 867.585 731.709 867.585C728.363 867.585 726.115 870.545 726.115 873.891C726.115 876.482 727.834 877.749 729.897 877.749Z" fill="white"/>
                        <path d="M746.417 866.21C748.941 866.21 750.409 867.56 750.845 869.145L751.323 866.394H752.933L750.727 878.914H749.125L749.603 876.138C748.622 877.748 746.626 879.098 744.127 879.098C740.705 879.098 738.601 876.549 739.288 872.632C739.977 868.709 742.979 866.21 746.417 866.21ZM746.467 867.61C743.851 867.61 741.486 869.447 740.941 872.633C740.362 875.794 742.065 877.698 744.673 877.698C747.247 877.698 749.671 875.769 750.225 872.658C750.795 869.539 749.033 867.61 746.467 867.61Z" fill="white"/>
                        <path d="M761.906 866.21C764.153 866.21 765.805 867.451 766.334 869.103L767.592 861.95H769.194L766.192 878.915H764.59L765.093 876.114C764.062 877.766 762.091 879.1 759.609 879.1C756.171 879.1 754.066 876.551 754.754 872.634C755.44 868.709 758.443 866.21 761.906 866.21ZM761.931 867.61C759.315 867.61 756.95 869.447 756.405 872.633C755.826 875.794 757.529 877.698 760.137 877.698C762.712 877.698 765.135 875.769 765.689 872.658C766.258 869.539 764.497 867.61 761.931 867.61Z" fill="white"/>
                        <path d="M772.053 866.394H773.655L771.449 878.914H769.847L772.053 866.394ZM772.321 862.838C772.438 862.15 773.034 861.672 773.696 861.672C774.342 861.672 774.778 862.15 774.644 862.838C774.527 863.526 773.931 864.029 773.285 864.029C772.623 864.029 772.212 863.526 772.321 862.838Z" fill="white"/>
                        <path d="M785.731 871.761C786.209 868.985 784.976 867.56 782.679 867.56C780.339 867.56 778.436 869.028 777.907 872.08V872.013L776.691 878.915H775.089L777.295 866.395H778.897L778.503 868.55C779.585 866.99 781.354 866.168 783.233 866.168C786.051 866.168 787.996 867.912 787.359 871.577L786.051 878.915H784.466L785.731 871.761Z" fill="white"/>
                        <path d="M797.085 866.21C799.559 866.21 801.077 867.543 801.513 869.12L801.991 866.395H803.601L801.354 879.234C800.734 882.748 797.916 885.062 794.469 885.062C791.24 885.062 789.286 883.41 789.245 880.794H790.83C791.057 882.496 792.407 883.662 794.73 883.662C797.112 883.662 799.242 882.077 799.745 879.234L800.273 876.14C799.292 877.75 797.296 879.1 794.814 879.1C791.376 879.1 789.271 876.551 789.959 872.634C790.645 868.709 793.647 866.21 797.085 866.21ZM797.136 867.61C794.52 867.61 792.155 869.447 791.61 872.633C791.031 875.794 792.734 877.698 795.342 877.698C797.917 877.698 800.34 875.769 800.894 872.658C801.463 869.539 799.702 867.61 797.136 867.61Z" fill="white"/>
                        <path d="M805.303 879.032C804.64 879.032 804.23 878.504 804.339 877.833C804.456 877.17 805.077 876.667 805.714 876.667C806.385 876.667 806.796 877.17 806.678 877.833C806.545 878.504 805.949 879.032 805.303 879.032Z" fill="white"/>
                        <path d="M809.48 879.032C808.818 879.032 808.407 878.504 808.516 877.833C808.633 877.17 809.254 876.667 809.891 876.667C810.562 876.667 810.973 877.17 810.855 877.833C810.721 878.504 810.125 879.032 809.48 879.032Z" fill="white"/>
                        <path d="M813.647 879.032C812.985 879.032 812.574 878.504 812.683 877.833C812.8 877.17 813.421 876.667 814.058 876.667C814.729 876.667 815.14 877.17 815.022 877.833C814.889 878.504 814.293 879.032 813.647 879.032Z" fill="white"/>
                        <path d="M767.189 828.654C742.802 829.657 719.553 814.753 711.112 790.545C706.111 776.201 706.993 760.77 713.601 747.087C720.209 733.407 731.748 723.121 746.092 718.12C775.712 707.787 808.198 723.485 818.521 753.099C821.776 762.439 822.548 772.49 820.751 782.175C819.738 787.612 814.529 791.187 809.076 790.191C803.639 789.182 800.051 783.953 801.06 778.516C802.225 772.257 801.722 765.747 799.61 759.691C792.923 740.507 771.888 730.355 752.683 737.03C743.392 740.27 735.915 746.937 731.634 755.797C727.353 764.66 726.783 774.66 730.023 783.954C736.71 803.135 757.759 813.305 776.95 806.618C781.787 804.931 786.126 802.329 789.85 798.881C793.9 795.119 800.242 795.36 803.998 799.42C807.756 803.474 807.515 809.809 803.458 813.568C797.701 818.904 791 822.929 783.541 825.529C778.138 827.412 772.634 828.43 767.189 828.654Z" fill="url(#paint2_linear_40_2453)"/>
                        <path d="M767.189 828.654C742.802 829.657 719.553 814.753 711.112 790.545C706.111 776.201 706.993 760.77 713.601 747.087C720.209 733.407 731.748 723.121 746.092 718.12C775.712 707.787 808.198 723.485 818.521 753.099C821.776 762.439 822.548 772.49 820.751 782.175C819.738 787.612 814.529 791.187 809.076 790.191C803.639 789.182 800.051 783.953 801.06 778.516C802.225 772.257 801.722 765.747 799.61 759.691C792.923 740.507 771.888 730.355 752.683 737.03C743.392 740.27 735.915 746.937 731.634 755.797C727.353 764.66 726.783 774.66 730.023 783.954C736.71 803.135 757.759 813.305 776.95 806.618C781.787 804.931 786.126 802.329 789.85 798.881C793.9 795.119 800.242 795.36 803.998 799.42C807.756 803.474 807.515 809.809 803.458 813.568C797.701 818.904 791 822.929 783.541 825.529C778.138 827.412 772.634 828.43 767.189 828.654Z" fill="#606060"/>
                        <path d="M526.961 842.866C514.23 842.866 503.91 853.186 503.91 865.917V869.466H550.013V865.917C550.012 853.186 539.692 842.866 526.961 842.866Z" fill="#C6304D"/>
                        <path d="M559.881 871.298H503.909V865.192H559.881C561.512 865.192 562.834 866.514 562.834 868.145V868.346C562.834 869.976 561.512 871.298 559.881 871.298Z" fill="#C6304D"/>
                        <path d="M805.629 1114.46L830.939 1179.37C830.939 1179.37 859.87 1220.23 878.249 1241.54C880.932 1244.65 866.176 1254.37 863.292 1251C844.245 1228.76 813.696 1197.23 813.696 1197.23L774.797 1121.51L790.349 1102.02L805.629 1114.46Z" fill="#EBA920"/>
                        <path d="M866.99 1050.53C873.405 1066.48 868.678 1074.14 863.549 1077.1C863.549 1077.1 844.225 1072.39 839.364 1070.24C839.364 1070.24 836.195 1084.34 833.711 1087.02L822.57 1077.22C822.57 1077.22 820.324 1066.81 825.427 1059.62C830.53 1052.44 838.84 1048.26 846.392 1049.38C853.944 1050.5 861.913 1058.98 867.767 1050.91" fill="#414042"/>
                        <path d="M863.549 1077.1C863.549 1077.1 860.281 1085.26 863.323 1089.93C866.365 1094.59 868.025 1094.78 868.025 1094.78C868.025 1094.78 862.366 1098.8 860.173 1103.42C857.98 1108.04 852.63 1111.24 845.204 1109.59C837.779 1107.94 833.769 1102.74 833.769 1102.74L823.819 1104.92C823.819 1104.92 815.945 1099.6 814.62 1093.57L824.045 1087.91C824.045 1087.91 819.273 1077.95 825.488 1076.49C831.703 1075.04 833.711 1087.02 833.711 1087.02L838.846 1069.79L863.549 1077.1Z" fill="#FCCAA7"/>
                        <path d="M833.769 1102.74C828.68 1097.83 828.841 1094.23 828.841 1094.23C828.841 1094.23 827.587 1099.89 829.639 1103.9L833.769 1102.74Z" fill="#E6E6E6"/>
                        <path d="M824.046 1087.91C824.046 1087.91 825.114 1089.51 830.459 1092.26C830.459 1092.26 823.786 1091.41 821.406 1089.49L824.046 1087.91Z" fill="#E6E6E6"/>
                        <path d="M812.291 1115.66L828.461 1105.87L814.62 1087.91L807.612 1094.23L812.291 1115.66Z" fill="#FFCA3C"/>
                        <path d="M869.524 1242.7L871.804 1253.23L874.684 1263.72C876.303 1266.13 882.637 1265.42 885.483 1264.93C887.675 1264.56 887.295 1260.6 886.926 1258.39L885.513 1249.95C885.513 1249.95 887.43 1255.3 888.614 1255.94C892.412 1257.98 891.744 1254.39 890.882 1253.21C884.523 1244.51 879.757 1239.79 879.757 1239.79L869.524 1242.7Z" fill="#FCCAA7"/>
                        <path d="M805.043 1358.42L801.834 1378.16C801.834 1378.16 839.245 1378.21 846.084 1378.16C852.923 1378.11 845.353 1361.95 828.46 1365.35C811.567 1368.74 821.85 1351.53 821.85 1351.53L805.043 1358.42Z" fill="#413539"/>
                        <path d="M790.621 1211.2C790.621 1211.2 827.409 1231.32 849.006 1241.48C870.603 1251.63 855.485 1271.21 849.006 1281.36C842.527 1291.51 822.077 1358.23 822.077 1358.23H805.092C805.092 1358.23 807.972 1331.39 810.131 1312.54C812.291 1293.69 825.931 1265.41 825.931 1265.41C825.931 1265.41 776.295 1255.25 750.378 1237.13C724.461 1219 733.58 1190.89 733.58 1190.89H770.535L790.621 1211.2Z" fill="#414042"/>
                        <path d="M706.225 1338.02L695.186 1355.82L711.024 1378.16C711.024 1378.16 722.543 1379.47 729.022 1378.16C735.501 1376.85 721.583 1363.15 715.824 1361.38L727.583 1336.96L706.225 1338.02Z" fill="#413539"/>
                        <path d="M739.807 1211.2C744.62 1253.56 745.58 1267.1 745.58 1267.1C745.58 1267.1 734.061 1273.87 726.382 1292.24C718.703 1310.61 706.224 1338.02 706.224 1338.02L725.902 1346.38L777.767 1274.56L773.416 1220.62L739.807 1211.2Z" fill="#414042"/>
                        <path d="M814.62 1093.57C811.663 1087.75 804.259 1085.99 799.016 1089.84C778.125 1105.21 732.38 1144.27 733.581 1190.89C734.001 1207.19 793.271 1223.21 792.476 1206.92C790.413 1164.66 809.509 1153.58 818.708 1137.96C827.907 1122.33 814.62 1093.57 814.62 1093.57Z" fill="#FFCA3C"/>
                        <path d="M881.833 1065.25L870.892 1064.18C871.628 1052.25 861.614 1041.65 848.091 1040.33C834.568 1039.01 822.692 1047.48 821.106 1059.32L821.027 1059.31L820.959 1060.01L820.626 1063.41L820.454 1065.17L881.26 1071.11C882.932 1071.27 884.415 1070.11 884.571 1068.51L884.578 1068.44C884.735 1066.84 883.505 1065.41 881.833 1065.25Z" fill="#C6573C"/>
                        <path d="M801.809 1088.84C791.076 1090.29 782.895 1103.66 780.229 1108.02C775.584 1115.61 774.661 1120.59 770.902 1121.1C767.661 1121.55 768.794 1119.31 766.76 1116.71L730.04 1167.12C730.04 1167.12 726.532 1173.08 728.824 1179.09C730.307 1182.99 733.51 1185.03 735.411 1186.24C756.238 1199.48 752.295 1199.89 761.404 1203.64C774.111 1208.88 785.529 1209.64 792.596 1209.53C792.503 1202.11 792.933 1193.9 794.252 1185.07C798.566 1156.21 810.388 1134.2 819.773 1120.24C822.83 1107.71 821.138 1096.84 811.628 1089.98C811.628 1089.98 807.098 1088.13 801.809 1088.84Z" fill="#C6573C"/>
                        <path d="M819.313 1107.75L839.888 1174.34C839.888 1174.34 865.805 1217.19 882.603 1239.79C885.056 1243.09 869.639 1251.7 867.005 1248.13C849.607 1224.57 821.406 1190.89 821.406 1190.89L788.055 1112.53C786.18 1107.82 786.915 1102.48 790.006 1098.62C793.508 1094.25 799.468 1092.49 804.968 1094.23C806.026 1094.26 811.395 1094.55 815.476 1099.01C818.638 1102.47 819.186 1106.41 819.313 1107.75Z" fill="#FFCA3C"/>
                        <path d="M1144.13 1224.23V1239.96H1099.14C1099.14 1239.96 1097.56 1224.23 1126.67 1224.23C1142.56 1224.23 1144.13 1224.23 1144.13 1224.23Z" fill="#414042"/>
                        <path d="M1121.63 1224.8C1126.67 1224.23 1129.74 1210.19 1129.74 1210.19H1144.13V1228.19L1129.29 1232.09L1121.63 1224.8Z" fill="#414042"/>
                        <path d="M1194.78 1224.23V1239.96H1149.78C1149.78 1239.96 1148.21 1224.23 1177.31 1224.23C1193.2 1224.23 1194.78 1224.23 1194.78 1224.23Z" fill="#414042"/>
                        <path d="M1172.27 1224.8C1177.31 1224.23 1180.38 1210.19 1180.38 1210.19H1194.78V1228.19L1179.93 1232.09L1172.27 1224.8Z" fill="#414042"/>
                        <path d="M1117.48 999.206V1079.85L1125 1217.45L1147.46 1217.76L1149.77 1137.26L1157.35 1053.88L1160.36 1139.84L1173.86 1217.45L1195.16 1220.49L1191.47 1125.26L1191.66 991.534L1175.91 959.328L1117.48 999.206Z" fill="#494949"/>
                        <path d="M1160.55 864.729L1158.94 889.646V905.526L1146.3 917.192L1134.31 902.933V863.072L1160.55 864.729Z" fill="#FAE3D9"/>
                        <path opacity="0.47" d="M1134.31 889.394C1134.31 889.394 1138.34 898.468 1142.57 899.98C1146.81 901.492 1159.12 886.815 1159.12 886.815L1160 873.191L1134.31 882.83L1134.31 889.394Z" fill="#7F7FC6"/>
                        <path d="M1128.08 855.889C1127.6 856.61 1128.91 873.298 1129.37 878.914C1129.47 880.105 1129.95 881.217 1130.76 882.102L1139.71 891.972C1141.85 894.324 1145.54 894.345 1147.7 892.018L1161.38 877.285C1162.09 876.522 1162.56 875.571 1162.74 874.546L1170.96 856.102C1171.36 853.833 1165.74 849.354 1163.73 848.225L1149.79 840.399C1148.36 839.596 1146.64 839.484 1145.12 840.095L1133.43 844.786C1131.87 845.41 1130.7 846.717 1130.24 848.327L1128.08 855.889Z" fill="#FAE3D9"/>
                        <path d="M1095.96 967.061L1117.04 1021.9L1119.23 1014.22L1191.58 1016.96L1192.13 1010.39L1191.31 1041.08L1239.39 958.365C1242.1 953.761 1241.54 947.93 1237.96 943.94L1193 893.248C1188.39 888.031 1181.39 885.626 1174.53 886.854L1158.93 889.667L1153.35 903.632C1150.8 910.026 1141.74 910.128 1139.03 903.785L1134.38 898.005L1118.57 905.473C1113.1 908.031 1109.11 912.941 1107.67 918.824L1095.96 967.061ZM1196.01 1000.05L1194.58 941.178L1211.87 958.058L1196.01 1000.05ZM1114.32 964.35L1118.16 954.478L1119.8 980.258L1114.32 964.35Z" fill="#F7931E"/>
                        <path d="M1135.61 847.059C1142.6 859.39 1161.3 853.636 1161.3 853.636L1161.09 868.639L1164.59 858.774C1164.59 858.774 1167.05 859.391 1166.85 862.884C1166.64 866.378 1164.17 866.995 1164.17 866.995L1162.74 874.547C1162.74 874.547 1170.96 866.995 1172.19 856.308C1173.42 845.621 1170.27 843.497 1163.9 836.92C1159.77 832.658 1148.6 830.6 1141.71 831.165C1135.47 831.677 1130.5 834.363 1128.28 840.208C1127.64 841.884 1126.36 841.862 1126.36 843.976C1126.36 853.841 1128.42 858.979 1128.42 858.979L1135.61 847.059Z" fill="#EF3554"/>
                        <path d="M412.095 1185.6L403.815 1209.14C403.815 1209.14 433.496 1224.89 443.962 1224.15C454.427 1223.4 448.001 1206.25 432.332 1206.23C422.314 1206.22 425.702 1192.03 425.702 1192.03L412.095 1185.6Z" fill="#413539"/>
                        <path d="M542.603 1196.17L542.499 1222.03C542.499 1222.03 576.516 1221.66 586.981 1220.91C597.446 1220.16 584.356 1205.16 568.687 1205.14C558.669 1205.13 555.157 1193.63 555.157 1193.63L542.603 1196.17Z" fill="#413539"/>
                        <path d="M480.164 1020.27L460.245 1082.92L417.102 1173.79L407.687 1193.63L425.857 1196.99L485.108 1108.64L521.116 1065.77L480.164 1020.27Z" fill="#414042"/>
                        <path d="M494.217 1096.92C492.61 1096.92 469.14 1059.95 471.391 1048.37L480.393 1017.51L507.077 1084.7L494.217 1096.92Z" fill="#303030"/>
                        <path d="M537.463 1026.24L545.991 1107.18L555.827 1196.35L538.618 1197.26L510.067 1110.5C510.067 1110.5 475.115 1034.77 477.513 1012.18C479.911 989.588 537.463 1026.24 537.463 1026.24Z" fill="#414042"/>
                        <path d="M614.74 927.555L581.462 916.056C581.068 910.422 581.898 904.612 584.11 899.006C589.645 884.981 602.362 875.929 616.374 874.411L601.846 911.224L614.74 927.555Z" fill="white"/>
                        <path d="M598.52 938.752L570.966 1008.57C568.677 1014.37 571.523 1020.93 577.325 1023.22C583.126 1025.51 589.685 1022.66 591.974 1016.86L619.528 947.042L598.52 938.752Z" fill="white"/>
                        <path d="M602.346 959.821C598.156 958.168 593.419 960.224 591.766 964.413L574.859 1007.25C573.205 1011.44 575.262 1016.18 579.451 1017.83C583.641 1019.49 588.378 1017.43 590.031 1013.24L606.937 970.4C608.592 966.211 606.536 961.474 602.346 959.821Z" fill="#E1E1FF"/>
                        <path d="M584.673 1011.84C584.134 1013.21 582.591 1013.88 581.226 1013.34C579.861 1012.8 579.191 1011.26 579.73 1009.89C580.269 1008.53 581.812 1007.86 583.177 1008.39C584.542 1008.93 585.212 1010.48 584.673 1011.84Z" fill="#FFD9E8"/>
                        <path d="M657.061 927.796C649.111 947.94 626.338 957.819 606.194 949.87C591.656 944.133 582.457 930.675 581.462 916.057L614.74 927.556L635.761 924.61L650.289 887.797C659.488 898.474 662.596 913.771 657.061 927.796Z" fill="white"/>
                        <path d="M531.926 855.718C541.365 868.125 547.546 865.006 543.733 868.817C543.733 868.817 525.602 869.328 520.811 868.615C520.811 868.615 521.371 881.694 519.822 884.63L507.684 878.732C507.684 878.732 503.233 870.174 506.018 862.673C508.802 855.171 515.125 849.531 522.039 848.7C528.953 847.869 532.256 860.896 535.491 852.438L531.926 855.718Z" fill="#404B69"/>
                        <path d="M543.733 868.817C543.733 868.817 542.797 876.735 546.584 880.087C550.371 883.438 551.877 883.202 551.877 883.202C551.877 883.202 547.85 888.07 547.017 892.632C546.184 897.194 542.236 901.277 535.306 901.61C528.376 901.943 527.313 900.527 527.313 900.527L524.062 914.108C524.062 914.108 512.617 907.108 510.018 902.155L511.526 887.725C511.526 887.725 504.958 880.164 510.083 877.402C515.208 874.64 519.823 884.63 519.823 884.63L520.248 868.341L543.733 868.817Z" fill="#FAE3D9"/>
                        <path opacity="0.47" d="M527.313 900.527C527.313 900.527 514.783 893.683 511.525 887.725L510.87 893.993C510.87 893.993 521.361 902.513 526.75 902.17L527.313 900.527Z" fill="#7F7FC6"/>
                        <path d="M594.289 1000.46L604.863 1009.03C605.552 1009.59 606.537 1009.58 607.224 1009.02L614.303 1003.25C615.196 1002.52 615.225 1001.17 614.365 1000.4L608.588 993.283C608.914 992.313 610.671 989.509 609.705 989.17L602.901 991.103C602.255 990.876 578.921 990.512 587.836 990.993L594.215 997.617C593.361 998.386 593.396 999.737 594.289 1000.46Z" fill="#FAE3D9"/>
                        <path d="M535.298 909.166L516.174 901.673C511.664 900.234 506.732 901.691 503.729 905.351L501.219 908.409C493.353 917.994 487.941 929.351 485.452 941.498L474.173 1006C472.707 1013.15 478.947 1019.51 486.127 1018.18L533.402 1025.3C537.051 1024.63 539.646 1021.37 539.487 1017.66L535.298 909.166Z" fill="#9CAEEF"/>
                        <path d="M514.934 906.895C500.264 913.833 507.526 959.017 484.705 945.15L468.863 1004.09C468.863 1004.09 465.685 1017.66 480.164 1020.27C494.643 1022.88 540.674 1027.49 540.674 1027.49L542.498 930.456C542.446 921.997 538.553 908.785 530.61 905.876C526.284 904.292 520.998 904.026 514.934 906.895Z" fill="#C6304D"/>
                        <path d="M534.741 912.952C537.731 918.201 539.739 923.95 540.666 929.919L548.691 981.591C549.013 984.196 551.22 986.156 553.844 986.168L590.693 988.853C595.846 989.228 599.616 993.87 598.928 998.991C598.34 1003.37 594.653 1006.66 590.239 1006.76L531.159 1008.06C528.586 1008.07 525.16 1001.85 524.756 999.314L511.958 928.315C511.129 923.096 514.138 913.534 518.412 910.427C520.851 908.654 523.745 907.744 526.66 907.74C529.848 907.736 532.777 909.506 534.355 912.276L534.741 912.952Z" fill="#9CAEEF"/>
                        <path d="M1021.96 1378.35H1129.17V1271.14H1021.96V1378.35Z" fill="#FFAC73"/>
                        <path d="M987.527 1378.35H1094.74V1271.14H987.527V1378.35Z" fill="#FCCAA7"/>
                        <path d="M1030.72 1359.72H1046.57V1271.14H1030.72V1359.72Z" fill="#CE7C32"/>
                        <path d="M1030.72 1378.35H1046.57V1355.7H1030.72V1378.35Z" fill="#CE7C32"/>
                        <path d="M1010.5 1271.16H1093.42V1188.24H1010.5V1271.16Z" fill="#FFAC73"/>
                        <path d="M983.866 1271.16H1066.79V1188.24H983.866V1271.16Z" fill="#FCCAA7"/>
                        <path d="M1017.27 1262.19H1029.53V1188.24H1017.27V1262.19Z" fill="#CE7C32"/>
                        <path d="M1017.27 1271.16H1029.53V1253.64H1017.27V1271.16Z" fill="#CE7C32"/>
                        <path d="M933.679 1379.71H1005.8V1307.59H933.679V1379.71Z" fill="#FFAC73"/>
                        <path d="M910.518 1379.71H982.641V1307.59H910.518V1379.71Z" fill="#FCCAA7"/>
                        <path d="M939.57 1375.19H950.236V1307.59H939.57V1375.19Z" fill="#CE7C32"/>
                        <path d="M939.57 1379.71H950.236V1364.47H939.57V1379.71Z" fill="#CE7C32"/>
                        <path d="M915.089 1309.28H987.212V1237.16H915.089V1309.28Z" fill="#FFAC73"/>
                        <path d="M891.928 1309.28H964.051V1237.16H891.928V1309.28Z" fill="#FCCAA7"/>
                        <path d="M920.981 1304.76H931.647V1237.16H920.981V1304.76Z" fill="#CE7C32"/>
                        <path d="M920.981 1309.28H931.647V1294.04H920.981V1309.28Z" fill="#CE7C32"/>
                        <defs>
                        <linearGradient id="paint0_linear_40_2453" x1="467.565" y1="1668.41" x2="1007.46" y2="396.664" gradientUnits="userSpaceOnUse">
                        <stop stop-color="#F288AE"/>
                        <stop offset="1" stop-color="#FFD1ED"/>
                        </linearGradient>
                        <linearGradient id="paint1_linear_40_2453" x1="1073.39" y1="427.759" x2="439.393" y2="1193.76" gradientUnits="userSpaceOnUse">
                        <stop stop-color="#FFADC2"/>
                        <stop offset="0.0442" stop-color="#FAA7C5"/>
                        <stop offset="0.6994" stop-color="#EB588D"/>
                        <stop offset="1" stop-color="#FA397E"/>
                        </linearGradient>
                        <linearGradient id="paint2_linear_40_2453" x1="850.985" y1="693.53" x2="756.698" y2="779.184" gradientUnits="userSpaceOnUse">
                        <stop stop-color="white"/>
                        <stop offset="1"/>
                        </linearGradient>
                        </defs>
                        </svg>

                </div>
            </div>
        </div>
    </section>

    <script src="{{asset('assets/global/js/jquery.min.js')}}"></script>
    <script src="{{asset('assets/global/js/select2.min.js')}}"></script>
    <script src="{{asset('assets/global/js/bootstrap.bundle.min.js')}}"></script>
    <script src="{{asset('assets/backend/js/pages/plugins/lord-icon-2.1.0.js')}}"></script>
    <script src="{{asset('assets/global/js/toastify-js.js')}}"></script>
    <script src="{{asset('assets/global/js/simplebar.min.js')}}"></script>
    <script src="{{asset('assets/global/js/helper.js')}}"></script>
    <script  src="{{asset('assets/backend/js/app.js')}}"></script>
    <script  src="{{asset('assets/backend/js/flatpickr.js')}}"></script>
	
    
    @include('partials.notify')
    @stack('script-include')
    @stack('script-push')


</body>
</html>
